<?php
if (isset($_SESSION['user'])) {
    header("Location: index.php");
}

// Connexion BDD
$bdd = new PDO('mysql:host=localhost;dbname=app_projet_bdd;charset=utf8', 'root', '');

if (isset($_POST['user']) && isset($_POST['password']) && isset($_POST['role'])) {
    session_start();
    if ($_POST['role'] == 'eleve') {
        $requete_eleve = $bdd->prepare("SELECT id_eleve, nom, prenom FROM eleve WHERE matricule=:matricule");
        $requete_eleve->bindParam(':matricule', $_POST['user']);
        $requete_eleve->execute();
        $eleve = $requete_eleve->fetch();
        $_SESSION['id_eleve'] = $eleve['id_eleve'];
        $_SESSION['user'] = $eleve['prenom'].' '.$eleve['nom'];
    } else if ($_POST['role'] == 'prof') {
        $requete_eleve = $bdd->prepare("SELECT id_professeur, nom_professeur, prenom_professeur FROM professeur WHERE nom_professeur LIKE :nom");
        $requete_eleve->bindParam(':nom', $_POST['user']);
        $requete_eleve->execute();
        $eleve = $requete_eleve->fetch();
        if (!$eleve) {
            header("Location: index.php");
        }
        $_SESSION['id_prof'] = $eleve['id_professeur'];
        $_SESSION['user'] = $eleve['prenom_professeur'].' '.$eleve['nom_professeur'];
    }
    else {
        $_SESSION['user'] = $_POST['user'];
    }

    $_SESSION['role'] = $_POST['role'];
    header("Location: index.php");
}
?>

<!DOCTYPE html>
<html lang="en" xmlns="http://www.w3.org/1999/html">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Connexion</title>

    <!-- Bootstrap Core CSS -->
    <link href="../bower_components/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- MetisMenu CSS -->
    <link href="../bower_components/metisMenu/dist/metisMenu.min.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link href="../dist/css/sb-admin-2.css" rel="stylesheet">

    <!-- Custom Fonts -->
    <link href="../bower_components/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->

</head>

<body>

    <div class="container">
        <div class="row">
            <div class="col-md-4 col-md-offset-4">
                <div class="login-panel panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Veuillez vous connecter</h3>
                    </div>
                    <div class="panel-body">
                        <form role="form" method="post">
                            <fieldset>
                                <div class="form-group">
                                    <select class="form-control" name="role">
                                        <option value="admin">Administrateur</option>
                                        <option value="prof">Professeur</option>
                                        <option value="eleve">Eleve</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <input class="form-control" placeholder="Utilisateur ou ID élève" name="user" autofocus>
                                </div>
                                <div class="form-group">
                                    <input class="form-control" placeholder="Mot de passe" name="password" type="password" value="">
                                </div>
                                <div class="checkbox">
                                    <label>
                                        <input name="remember" type="checkbox" value="Remember Me">Se souvenir de moi
                                    </label>
                                </div>
                                <!-- Change this to a button or input when using this as a form -->
                                <input type="submit" value="Connexion">
                            </fieldset>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- jQuery -->
    <script src="../bower_components/jquery/dist/jquery.min.js"></script>

    <!-- Bootstrap Core JavaScript -->
    <script src="../bower_components/bootstrap/dist/js/bootstrap.min.js"></script>

    <!-- Metis Menu Plugin JavaScript -->
    <script src="../bower_components/metisMenu/dist/metisMenu.min.js"></script>

    <!-- Custom Theme JavaScript -->
    <script src="../dist/js/sb-admin-2.js"></script>

</body>

</html>
